//
//  MCQueryElementBodyView.h
//  MCApplication
//
//  Created by Michael Clark on 22/07/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCCSWBodyView.h"

#import <MCFoundation/MCQueryProcessor.h>


@class MCQueryCriteria, MCQueryElementSubView;
@class MCPDocument;

@interface MCQueryElementBodyView : MCCSWBodyView {
	NSPopUpButton*          _anyAllPopUp;
	NSString*               _combineSentenceParts[2];
	NSRect                  _combineSentenceRects[2];
	MCQueryBooleanType      _booleanType;

	
	MCQueryCriteria*       _criteria;
	NSDictionary*          _config;
	
	NSMutableArray*        _subElements;

	float               _preferredHeight;
	NSRect              plusButtonRect;
	NSTrackingRectTag   plusTrackingRect;
	NSPoint             linePoint1;
	NSPoint             linePoint2;
	
	MCPDocument*   __document;
}

- (NSDictionary*)viewConfig;

// Can be called to force the body to configure its sizing, otherwise it will do this when it gets added to the window
- (void)setupViewSizing;

- (void)addSubElement;
- (void)removeSubElement: (MCQueryElementSubView*)subelement;

- (MCQueryCriteria *)criteria;
- (void)setCriteria:(MCQueryCriteria *)aCriteria;

- (NSDictionary *)config;
- (void)setConfig:(NSDictionary *)aConfig;

- (MCPDocument *)document;
- (void)setDocument:(MCPDocument *)aDocument;

@end
